/********************************************************************
 * (C) Copyright 1998 by Hewlett-Packard GmbH. All rights reserved. *
 ********************************************************************/

/* ***********************************************************************
   *                                                                     *
   * errcapi.h                                                             *
   * Christian Zurhorst, BID R&D, 26. Sep. 1997                          *
   *                                                                     *
   * utilities for enhanced error handling                               *
   *                                                                     *
   ***********************************************************************
*/

#ifndef _ERRCAPI_H_
#define _ERRCAPI_H_

#ifndef __cplusplus
      
/* This structure is used in error.c and globals initialized in errdata.c */

typedef struct _ErrorDescription
{
  const char *errname;
  const char *error;
  const b_errtype errcode;
  const char **lookup1;
  const char **lookup2;
  const char **lookup3;
  const char **lookup4;
  const char **lookup5;
} ErrorDescription;

#endif


/* --------------------------------------------------------------------------
 * Exported functions
 * -------------------------------------------------------------------------- */

#ifdef __cplusplus
extern "C" {
#endif


/* --------------------------------------------------------------------------
 * BestFuncParamMsg is used by ALL parameter checking routines to record
 * the error if the  check fails.  It is aliased by the macro __FCT_PARAM_MSG
 * which is called by the B_FCT_PARAM_CHK series of macros.
 * -------------------------------------------------------------------------- */

void EXPORT BestFuncParamMsg( b_handletype handle, 
                              b_ccharptrtype pFuncName, 
                              b_ccharptrtype param, 
                              b_ccharptrtype reason
                              );


/* BestLastErrorParamSet

   set a parameter for the next error message, has to be called before
   BestLastErrorSet

   arguments:
   index	- which parameter
   errpar	- the parameter
*/

void EXPORT	BestLastErrorParamSet (b_handletype handle,
				       b_errparamtype index, 
                                       b_int64 errpar
                                       );


/* BestLastErrorAllParamsSet

   sets all parameters

   arguments:
   errpar1..5	- parameters
*/

void EXPORT	BestLastErrorAllParamsSet (b_handletype handle,
					   b_int64 errpar1,
					   b_int64 errpar2,
					   b_int64 errpar3,
					   b_int64 errpar4,
					   b_int64 errpar5
  					   );

void EXPORT	BestLastErrorAllParamsGet (b_handletype,
					   b_int64ptr errpar1,
					   b_int64ptr errpar2,
					   b_int64ptr errpar3,
					   b_int64ptr errpar4,
					   b_int64ptr errpar5
  					   );

void EXPORT	BestLastErrorParamStringSet (b_handletype handle,
					     b_ccharptrtype s
                                             );

/* BestLastErrorSet

   compose the error message

   arguments:
   err		- error code
*/

b_errtype EXPORT BestLastErrorSet (b_handletype handle, b_errtype err);


/* BestLastErrorGet

   get the error message stored in the handle structure
*/

b_errtype EXPORT BestLastErrorGet (b_handletype handle);
b_ccharptrtype EXPORT BestLastErrorStringGet (b_handletype handle);


void		BestLastErrorStore (b_handletype handle, b_errtype err);

/* get error w/o handle... */
b_ccharptrtype EXPORT BestErrorStringGet( /* @errstrget */
  b_errtype     error
  );



#ifdef __cplusplus
}
#endif

#endif /* _ERROR_H_ */
